function [K0,W0,gamma10,obj20] = Initial_controller_design(A,B,D,Nc,Mc,Cx,V0,alpha1,alpha2)

[n,m] = size(B);
[~,l] = size(D);

Rk = inv(V0'*V0);


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
gamma10 = sdpvar(1);
X10 = sdpvar(m,n);
P10 = sdpvar(n,n);

LMI1 = blkvar();
LMI1(1,1) = (A*P10+B*X10)+(A*P10+B*X10)';
LMI1(1,2) = D;
LMI1(1,3) = Mc;
LMI1(1,4) = P10*Nc';
LMI1(1,5) = P10*Cx';

LMI1(2,2) = -gamma10*eye(l);

LMI1(3,3) = -eye(n);

LMI1(4,4) = -eye(n);

LMI1(5,5) = -gamma10*eye(n);

LMI1 = sdpvar(LMI1);

%%%%%%%LMI2
S0 = sdpvar(n,n);

LMI2 = blkvar();
LMI2(1,1) = (A*P10+B*X10)+(A*P10+B*X10)';
LMI2(1,2) = B;
LMI2(1,3) = Mc;
LMI2(1,4) = P10*Nc';
LMI2(1,5) = P10;


LMI2(2,2) = -inv(Rk);

LMI2(3,3) = -eye(n);
LMI2(4,4) = -eye(n);
LMI2(5,5) = -S0;

LMI2 = sdpvar(LMI2);


%%%%%%%%%%%%%%%%%%
const = [];
obj1 = alpha1*gamma10 + alpha2*trace(S0);

const = [const, P10 >= eps*eye(n)];
const = [const, gamma10 >= eps];
const = [const, LMI1 <= -eps*eye(4*n+l)];

const = [const, S0 >= eps*eye(n)];
const = [const, LMI2 <= -eps*eye(4*n+m)];

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%5
ops = sdpsettings('solver','mosek','verbose','1');
optimize(const,[]);

K0 =  value(X10)*inv(value(P10));
W0 = sqrt(inv(value(S0)));
gamma10 = value(gamma10);
obj20 = 1.0e-6*value(obj1);

% save K0.mat K0
% save gamma10.mat gamma10
% save W0.mat W0
% save obj20.mat obj20


